/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.EndControl;
import control.EnemyControl;
import control.GameControl;
import control.MainControl;
import control.MenuControl;
import data.Constants;
import data.Debugging;
import data.Theme;
import org.lwjgl.input.Keyboard;
import view.Fonts;

public class KeyboardInput {
    private static long lastEscape = System.currentTimeMillis();
    private static long lastSpace = System.currentTimeMillis();
    private static long lastFont = System.currentTimeMillis();
    private static long lastMovement = System.currentTimeMillis();

    public static void clearBuffer() {
        while (Keyboard.next()) {
            Keyboard.getEventCharacter();
        }
    }

    public static void update(GameControl gc) {
        if (Keyboard.isCreated()) {
            if (Debugging.bDebugBuild) {
                if (Keyboard.isKeyDown(22) && System.currentTimeMillis() - lastFont > 150L) {
                    Theme.bUseBlending = !Theme.bUseBlending;
                    lastFont = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown(48) && System.currentTimeMillis() - lastFont > 150L) {
                    Theme.nextClearColor();
                    lastFont = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown(37)) {
                    if (System.currentTimeMillis() - lastFont > 150L) {
                        Debugging.fEnemyColorOffset += 0.1f;
                        lastFont = System.currentTimeMillis();
                    }
                } else if (Keyboard.isKeyDown(50) && System.currentTimeMillis() - lastFont > 150L) {
                    Debugging.fEnemyColorOffset -= 0.1f;
                    lastFont = System.currentTimeMillis();
                }
                Debugging.fEnemyColorOffset %= 1.0f;
                if (Keyboard.isKeyDown(36) && System.currentTimeMillis() - lastFont > 150L) {
                    Fonts.useNextFont();
                    System.out.println("currentfont = " + Fonts.whatFont());
                    lastFont = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown(49) && System.currentTimeMillis() - lastFont > 150L) {
                    Fonts.usePreviousFont();
                    System.out.println("currentfont = " + Fonts.whatFont());
                    lastFont = System.currentTimeMillis();
                }
            }
            if (Constants.currentGameState == 1 && Keyboard.next() && Keyboard.getEventKey() == 57) {
                if (Keyboard.getEventKeyState()) {
                    gc.reversedPlayer();
                } else {
                    gc.originalPlayer();
                }
            }
            if (Constants.currentGameState != 3) {
                Keyboard.isKeyDown(33);
                Keyboard.isKeyDown(34);
            }
            if ((Keyboard.isKeyDown(54) || Keyboard.isKeyDown(42)) && System.currentTimeMillis() - lastSpace > 200L) {
                Theme.useNextTheme();
                lastSpace = System.currentTimeMillis();
            }
            if (Keyboard.isKeyDown(1) && Constants.currentGameState == 1 && System.currentTimeMillis() - lastEscape > 2000L) {
                Constants.currentGameState = 0;
                gc.endGame();
                lastEscape = System.currentTimeMillis();
                MenuControl.menuReset();
                EnemyControl.yVel = 0.0f;
                EnemyControl.xVel = 0.0f;
                Constants.MULTIPLIER = 1;
                Constants.SCORE = 0;
            }
            boolean bMoving = false;
            if (Keyboard.isKeyDown(17) || Keyboard.isKeyDown(200)) {
                if (Constants.currentGameState == 0) {
                    MainControl.menuControl.moveUp();
                } else if (EndControl.isScoreEntered() && Constants.currentGameState == 3 && EndControl.move) {
                    MainControl.menuControl.moveUp();
                } else if (Constants.currentGameState == 1 && EnemyControl.yVel < Constants.MAX_PLAYER_SPEED) {
                    EnemyControl.yVel += Constants.PLAYER_SPEED_INCREASE;
                }
                bMoving = true;
            } else if (Keyboard.isKeyDown(31) || Keyboard.isKeyDown(208)) {
                if (Constants.currentGameState == 0) {
                    MainControl.menuControl.moveDown();
                } else if (EndControl.isScoreEntered() && Constants.currentGameState == 3 && EndControl.move) {
                    MainControl.menuControl.moveDown();
                } else if (EnemyControl.yVel > -Constants.MAX_PLAYER_SPEED) {
                    EnemyControl.yVel -= Constants.PLAYER_SPEED_INCREASE;
                }
                bMoving = true;
            }
            if (Keyboard.isKeyDown(30) || Keyboard.isKeyDown(203)) {
                if (Constants.currentGameState == 0) {
                    MainControl.menuControl.moveLeft();
                } else if (EndControl.isScoreEntered() && Constants.currentGameState == 3 && EndControl.move) {
                    MainControl.menuControl.moveLeft();
                } else if (Constants.currentGameState == 1) {
                    if (Constants.BALANCE_ON) {
                        Constants.BALANCE = Constants.BALANCE > -1.0f && Constants.BALANCE < 0.0f ? (Constants.BALANCE -= Constants.BALANCE_CHANGE) : (Constants.BALANCE -= 5.0f * Constants.BALANCE_CHANGE);
                    }
                    if (EnemyControl.xVel < Constants.MAX_PLAYER_SPEED) {
                        EnemyControl.xVel += Constants.PLAYER_SPEED_INCREASE;
                    }
                }
                bMoving = true;
            } else if (Keyboard.isKeyDown(32) || Keyboard.isKeyDown(205)) {
                if (Constants.currentGameState == 0) {
                    MainControl.menuControl.moveRight();
                } else if (EndControl.isScoreEntered() && Constants.currentGameState == 3 && EndControl.move) {
                    MainControl.menuControl.moveRight();
                } else if (Constants.currentGameState == 1) {
                    if (Constants.BALANCE_ON) {
                        Constants.BALANCE = Constants.BALANCE < 1.0f && Constants.BALANCE > 0.0f ? (Constants.BALANCE += Constants.BALANCE_CHANGE) : (Constants.BALANCE += 5.0f * Constants.BALANCE_CHANGE);
                    }
                    if (EnemyControl.xVel > -Constants.MAX_PLAYER_SPEED) {
                        EnemyControl.xVel -= Constants.PLAYER_SPEED_INCREASE;
                    }
                }
                bMoving = true;
            }
            if (bMoving) {
                lastMovement = System.currentTimeMillis();
            }
            if (Constants.currentGameState != 3) {
                KeyboardInput.clearBuffer();
            }
        }
    }

    public static long getLastMoveTime() {
        return lastMovement;
    }

    public static boolean isKeyActive(int iKeyInput) {
        boolean bRet = false;
        if (iKeyInput == 200 && (Keyboard.isKeyDown(200) || Keyboard.isKeyDown(17))) {
            bRet = true;
        } else if (iKeyInput == 203 && (Keyboard.isKeyDown(203) || Keyboard.isKeyDown(30))) {
            bRet = true;
        } else if (iKeyInput == 208 && (Keyboard.isKeyDown(208) || Keyboard.isKeyDown(31))) {
            bRet = true;
        } else if (iKeyInput == 205 && (Keyboard.isKeyDown(205) || Keyboard.isKeyDown(32))) {
            bRet = true;
        } else if (iKeyInput == 54 && (Keyboard.isKeyDown(54) || Keyboard.isKeyDown(42))) {
            bRet = true;
        } else if (iKeyInput == 57 && Keyboard.isKeyDown(57)) {
            bRet = true;
        }
        return bRet;
    }
}

